function header = create_header(modulation_decision,QAM_decision,OFDM_decision,...
    file_format,file_name,nr_bits_input,nr_packages,nr_columns,nr_parity_bits,...
    added_number_zeros, added_number_zeros_hamming,nr_OFDM_symbols_package,k)

% Convert from decimal to binary
modulation_decision_bin = dec2bin(modulation_decision)-'0';
modulation_decision_bin = zero_padding_front(modulation_decision_bin,1);

QAM_decision_bin = dec2bin(QAM_decision)-'0';
QAM_decision_bin = zero_padding_front(QAM_decision_bin,7);

file_format_bin = dec2bin(file_format)';
% Convert from char to double with the zero
file_format_bin = file_format_bin(:)'-'0';
file_format_bin = zero_padding_front(file_format_bin,40);

file_name_bin = dec2bin(file_name)';
file_name_bin = file_name_bin(:)'-'0';
file_name_bin = zero_padding_front(file_name_bin,640);

nr_bits_input_bin = dec2bin(nr_bits_input)-'0';
nr_bits_input_bin = zero_padding_front(nr_bits_input_bin,30);

nr_packages_bin = dec2bin(nr_packages)-'0';
nr_packages_bin = zero_padding_front(nr_packages_bin,20);

nr_columns_bin = dec2bin(nr_columns)-'0';
nr_columns_bin = zero_padding_front(nr_columns_bin,30);

nr_parity_bin = dec2bin(nr_parity_bits)-'0';
nr_parity_bin = zero_padding_front(nr_parity_bin,5);

added_number_zeros_bin = dec2bin(added_number_zeros)-'0';
added_number_zeros_bin = zero_padding_front(added_number_zeros_bin,13);

added_number_zeros_hamming_bin = dec2bin(added_number_zeros_hamming)-'0';
added_number_zeros_hamming_bin = zero_padding_front(added_number_zeros_hamming_bin,5);

nr_OFDM_symbols_package_bin = dec2bin(nr_OFDM_symbols_package)-'0';
nr_OFDM_symbols_package_bin = zero_padding_front(nr_OFDM_symbols_package_bin,24);

k_bin = dec2bin(k)-'0';
k_bin = zero_padding_front(k_bin,3);

% Repeat each block three times
% modulation_decision_header = [modulation_decision_bin,modulation_decision_bin,modulation_decision_bin];
% QAM_decision_header = [QAM_decision_bin,QAM_decision_bin,QAM_decision_bin];
% OFDM_decision_header = [OFDM_decision,OFDM_decision,OFDM_decision];
% file_format_header = [file_format_bin,file_format_bin,file_format_bin];
% file_name_header = [file_name_bin,file_name_bin,file_name_bin];
% nr_bits_input_header = [nr_bits_input_bin,nr_bits_input_bin,nr_bits_input_bin];
% nr_packages_header = [nr_packages_bin,nr_packages_bin,nr_packages_bin];
% nr_columns_header = [nr_columns_bin,nr_columns_bin,nr_columns_bin];
% nr_parity_header = [nr_parity_bin,nr_parity_bin,nr_parity_bin];
% added_number_zeros_header = [added_number_zeros_bin,added_number_zeros_bin,added_number_zeros_bin];
% added_number_zeros_hamming_header = [added_number_zeros_hamming_bin,added_number_zeros_hamming_bin,added_number_zeros_hamming_bin];


% header = [modulation_decision_header,QAM_decision_header,OFDM_decision_header, file_format_header,...
%          file_name_header,nr_bits_input_header,...
%          nr_packages_header, nr_columns_header,nr_parity_header,...
%          added_number_zeros_header,added_number_zeros_hamming_header];

header = [modulation_decision_bin,QAM_decision_bin,OFDM_decision, file_format_bin,...
          file_name_bin,nr_bits_input_bin,...
          nr_packages_bin, nr_columns_bin,nr_parity_bin,...
          added_number_zeros_bin,added_number_zeros_hamming_bin,nr_OFDM_symbols_package_bin,...
          k_bin];


end